param(
    [Parameter(Mandatory=$false)]
    [string]$envFilePath = "published.env",
    [Parameter(Mandatory=$false)]
    [string]$userEnvFilePath = "published.user.env"
)

Set-StrictMode -Version 2  # Enable strict error reporting

function Load-EnvFile {
    param(
        [string]$filePath
    )

    if (!(Test-Path $filePath)) {
        Write-Warning "File $filePath not found. Skipping."
        return
    }

    Get-Content $filePath -Encoding UTF8 | ForEach-Object {
        $line = $_.Trim()

        if ([string]::IsNullOrWhiteSpace($line) -or $line.StartsWith('#')) {
            Write-Debug "Skipping line: $line"
        } else {
            Write-Debug "Processing line: $line"

            # Divide en solo dos partes: nombre y valor
            $name, $value = $line -split '=', 2
            $name = $name.Trim()
            $value = $value.Trim()

            Write-Debug "Setting $name to $value"
            Set-Content env:\$name $value
        }
    }
}

try {
    Write-Debug "Loading environment variables from $envFilePath"
    Load-EnvFile -filePath $envFilePath

    Write-Debug "Loading user-defined environment variables from $userEnvFilePath"
    Load-EnvFile -filePath $userEnvFilePath
	
	if (-not (Test-Path "$env:GX_VOLUMES_BASE_PATH/data")) {
		Write-Debug "Creating required directories under $env:GX_VOLUMES_BASE_PATH/data"
		New-Item -ItemType Directory -Path "$env:GX_VOLUMES_BASE_PATH/data/mssql/data" -Force
		New-Item -ItemType Directory -Path "$env:GX_VOLUMES_BASE_PATH/data/kbs" -Force
	}

    Write-Debug "Starting docker-compose"
    docker-compose up gxweb --wait
} catch {
    Write-Error "An error occurred: $_"  # Log any errors
}
