# Overview

This distribution provides a `docker-compose.yml` file and an environment variables file to facilitate the deployment of a GeneXus® Next Desktop Web instance on your local machine.

The GXnext Docker Compose cluster consists of several core services:

  - Integrated Development Environment (aka IDE): **gxweb** container.
  - Backend services required by the IDE: **gxms** container.
  - Microsoft SQL Server for database storage: **sql** container.
  - PostgreSQL for database storage: **pgsql** container.
  - Android compilation environment for GeneXus generated Android applications: **android** container.

# Table of Contents

  - [Requirements](#requirements)
  - [Getting Started](#getting-started)
      - [Settings](#settings)
      - [Run GeneXus Next Desktop (Start Containers)](#run-genexus-next-desktop-start-containers)
      - [Create Your First Knowledge Base](#create-your-first-knowledge-base)
      - [Stop Containers](#stop-containers)
      - [Documentation](#documentation)
  - [Advanced](#advanced)
      - [Enabling the Android Container](#enabling-the-android-container)
      - [Overriding Environment Variables](#overriding-environment-variables)
      - [User Environment Variables for Configuring Docker Compose](#user-environment-variables-for-configuring-docker-compose)
      - [Ports Usage for Docker Compose](#ports-usage-for-docker-compose)
  - [Troubleshooting](#troubleshooting)
      - [Port Conflict](#port-conflict)
  - [License](#license)

# Requirements

  - **OS**: macOS, Linux or Windows.
  - **Browser**: A modern, up-to-date web browser.
  - **Docker**: [Docker Engine🔗](https://docs.docker.com/engine/install/) or [Rancher Desktop🔗](https://rancherdesktop.io/).

> **Note**: Your Docker installation must include [Docker Compose🔗](https://docs.docker.com/compose/install/), a tool for defining and running multi-container Docker applications.

Check the detailed requirements at [Run GeneXus Next Desktop Web🔗](https://docs.genexus.com/en/wiki?48854,HowTo%3A+Install+and+run+GeneXus+Next+Desktop).

# Getting Started

## Settings

## Run GeneXus Next Desktop (Start Containers)

1.  Start the containers:

      - In a Bash-based shell:
        ```bash
        ./dup.sh
        ```
      - In a PowerShell-based shell:
        ```powershell
        ./dup.ps1
        ```

2. Open your browser and navigate to [http://localhost:3000](http://localhost:3000).

Done\! You can now start prototyping with GeneXus Next Desktop.

## Create Your First Knowledge Base

Refer to the document [GXnext - Getting Started🔗](https://docs.genexus.com/en/wiki?49074,Getting+Started+with+GeneXus+Next+-+Creating+a+New+Application) to learn how to create your first Knowledge Base (KB).

## Stop Containers

1. Stop the running containers:
      - In a Bash-based shell:
        ```bash
        ./ddown.sh
        ```
      - In a PowerShell-based shell:
        ```powershell
        ./ddown.ps1
        ```

## Documentation

Explore the full documentation for GeneXus Next at [GeneXus Next - Table of Contents🔗](https://docs.genexus.com/en/wiki?57864,Table+of+contents%3AGeneXus+Next).

# Advanced

## Enabling the Android Container

By default, the Android container is disabled to optimize system resource usage (memory and processor). The Android container is only needed when you plan to compile GeneXus-generated Android applications. If you don't require Android compilation capabilities, it's recommended to keep it disabled.

To enable the Android container:

1. [Stop the running containers](#stop-containers)

2. Edit the `docker-compose.yml` file:
  - Open the `docker-compose.yml` file in your preferred text editor.
  - Locate the `gxms` service section.
  - Find the `depends_on` configuration within the `gxms` service.

3. Uncomment the Android dependency:
  - Remove the comment from the `android` line so the `depends_on` section looks like this:
      ```yaml
      depends_on:
        - sql
        - pgsql
        - android
      ```

4. [Start the containers again](#run-genexus-next-desktop-start-containers)

The Android container will now be started and configured for use with your GeneXus Next environment.

## Overriding Environment Variables

- **Default Configuration**: The primary environment variables are defined in `published.env`.
- **Custom Overrides**: To override specific variables, create a `published.user.env` file from the `published.user.env.template`.
- **Precedence**: Variables in `published.user.env` take precedence over those in `published.env` during runtime.

## User Environment Variables for Configuring Docker Compose

| Variable               | Description                                           | Default Value       |
| ---------------------- | ----------------------------------------------------- | ------------------- |
| `GX_VOLUMES_BASE_PATH` | Base path for database volumes (PostgreSQL, SQL Server). | `.` (current directory) |

## Ports Usage for Docker Compose

| Container | Tool/Service                       | Container Port | Host Port | Description                                     |
| --------- | ---------------------------------- | -------------- | --------- | ----------------------------------------------- |
| `sql`     | Azure SQL Edge                     | `1433`         | `1433`    | Used for database connections via Azure SQL Edge. |
| `pgsql`   | PostgreSQL with pgvector extension | `5432`         | `5432`    | Default PostgreSQL port for connections.          |
| `gxms`    | GeneXus backend                    | `8001`         | `8001`    | Internal port for GeneXus backend processes.    |
|           |                                    | `8080`         | `8080`    | Endpoint for Java-generated applications.       |
|           |                                    | `8082`         | `8082`    | Endpoint for .NET-generated applications.       |
|           |                                    | `4200`         | `4200`    | Endpoint for Angular-generated applications.    |
| `gxweb`   | GeneXus Next IDE                   | `3000`         | `3000`    | Web interface.              |

# Troubleshooting

This section covers solutions for the most common issues. If you can't find a solution here, please consult the [Troubleshooting GeneXus Next Desktop Web🔗](https://docs.genexus.com/en/wiki?57931,GeneXus+Next+Desktop+-+Troubleshooting+for+installation+and+execution) guide for additional tips and instructions on how to report a problem.

## Port Conflict

If a port conflict arises because another application is using a required port, Docker will fail to start the affected container. For example, if you already have a PostgreSQL instance running on port `5432`, the process will fail:

```powershell
PS C:\Run-GeneXusNext-Local> .\dup.ps1
[+] Running 3/4
 - Container genexus-pgsql-1  Starting                                                                             0.2s
 ✔ Container genexus-sql-1    Running                                                                              0.0s
 ✔ Container genexus-gxms-1   Running                                                                              0.0s
 ✔ Container genexus-gxweb-1  Running                                                                              0.0s
Error response from daemon: driver failed programming external connectivity on endpoint genexus-pgsql-1 (...):
Bind for 0.0.0.0:5432 failed: port is already allocated
```

To resolve this, modify the `docker-compose.yml` file to map the container's port to a different host port:

1. Locate the `ports` section of the conflicting service (e.g., `pgsql`).
1. Change the host port (the value before the `:`) to an available port on your machine.

For example, to change the host port for the `pgsql` service from `5432` to `5433`:

**Before:**

```yaml
  pgsql:
    # ...
    ports:
      - 5432:5432
    # ...
```

**After:**

```yaml
  pgsql:
    # ...
    ports:
      - 5433:5432  # Host port updated to 5433, container port remains 5432
    # ...
```

After saving the changes, run the start command again.

# License
By using GeneXus® Next, you agree to the terms and conditions and privacy policies of the software.

- [**Terms and Conditions**🔗](http://genexus.com/products/genexus-next-terms-and-conditions)
- [**Privacy Policy**🔗](https://www.genexus.com/privacy)

This information can also be found in the **Help > About** menu within the GeneXus Next Desktop Web.

---
GeneXus® is a Globant company. All right reserved.
